<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SaleDetail extends Model
{
    use HasFactory;

    protected $fillable = [
        'sale_id', 
        'product_id', 
        'quantity', 
        'price_at_moment_usd', 
        'subtotal_usd'
    ];

    // Relación: Pertenece a una Venta
    public function sale()
    {
        return $this->belongsTo(Sale::class);
    }

    // Relación: Pertenece a un Producto
    public function product()
    {
        return $this->belongsTo(Product::class);
    }
}