<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            // Relación con la tabla units que acabas de crear
            $table->foreignId('unit_id')->constrained(); 
            // Precio base en Dólares
            $table->decimal('price_usd', 10, 2); 
            $table->boolean('is_active')->default(true); // Para no borrar historial
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};