<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('sales', function (Blueprint $table) {
            $table->id();
            // Relaciones
            $table->foreignId('client_id')->constrained();
            $table->foreignId('user_id')->constrained(); // Usuario que hace la venta
            
            $table->date('sale_date'); // Fecha de la venta
            
            // DATOS CRÍTICOS DE MONEDA
            $table->decimal('bcv_rate', 12, 4); // Tasa BCV usada ese día
            $table->decimal('total_usd', 12, 2); // Total final en $
            $table->decimal('total_ves', 12, 2); // Total final en Bs
            
            $table->text('notes')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('sales');
    }
};