<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('sale_details', function (Blueprint $table) {
            $table->id();
            // Si borras una venta, se borran sus detalles (cascade)
            $table->foreignId('sale_id')->constrained()->onDelete('cascade');
            $table->foreignId('product_id')->constrained();
            
            $table->decimal('quantity', 10, 2); // Cantidad (ej: 1.5 kg)
            $table->decimal('price_at_moment_usd', 10, 2); // Precio histórico
            $table->decimal('subtotal_usd', 12, 2);
            
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('sale_details');
    }
};