<div class="py-6">
    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg p-6">
            
            <h2 class="text-2xl font-bold text-gray-800 mb-6">🧠 Inteligencia de Clientes</h2>

            <div class="mb-6 p-4 bg-gray-50 rounded-lg">
                <label class="block text-gray-700 font-bold mb-2">Analizar Cliente:</label>
                <select wire:model.live="selectedClientId" class="w-full md:w-1/2 border-gray-300 rounded-lg shadow-sm">
                    <option value="">-- Seleccionar --</option>
                    @foreach($clients as $client)
                        <option value="{{ $client->id }}">{{ $client->name }}</option>
                    @endforeach
                </select>
            </div>

            @if($selectedClientId && count($stats) > 0)
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-100">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-bold text-gray-500 uppercase">Producto</th>
                                <th class="px-6 py-3 text-left text-xs font-bold text-gray-500 uppercase">Última Compra</th>
                                <th class="px-6 py-3 text-left text-xs font-bold text-gray-500 uppercase">Ritmo Habitual</th>
                                <th class="px-6 py-3 text-left text-xs font-bold text-gray-500 uppercase">Diagnóstico</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @foreach($stats as $row)
                                <tr class="hover:bg-gray-50 transition">
                                    
                                    <td class="px-6 py-4 whitespace-nowrap font-medium text-gray-900">
                                        {{ $row['product_name'] }}
                                    </td>

                                    <td class="px-6 py-4 whitespace-nowrap">
                                        @if($row['status'] == 'never')
                                            <span class="text-gray-400">-</span>
                                        @else
                                            <div class="text-sm text-gray-900 font-bold">{{ $row['last_date'] }}</div>
                                            <div class="text-xs text-gray-500">Hace {{ $row['days_since'] }} días</div>
                                        @endif
                                    </td>

                                    <td class="px-6 py-4 whitespace-nowrap">
                                        @if($row['status'] == 'never')
                                            <span class="text-xs text-gray-400">Sin datos</span>
                                        @else
                                            <span class="text-sm text-gray-600">Compra cada </span>
                                            <span class="font-bold text-indigo-600">{{ $row['frequency'] }}</span>
                                        @endif
                                    </td>

                                    <td class="px-6 py-4 whitespace-nowrap">
                                        @if($row['status'] == 'danger')
                                            <div class="flex items-center text-red-600 bg-red-100 px-3 py-1 rounded-full w-max animate-pulse">
                                                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path></svg>
                                                <span class="text-xs font-bold">{{ $row['alert_message'] }}</span>
                                            </div>
                                        
                                        @elseif($row['status'] == 'warning')
                                            <span class="px-3 py-1 inline-flex text-xs leading-5 font-semibold rounded-full bg-yellow-100 text-yellow-800">
                                                ⚠️ {{ $row['alert_message'] }}
                                            </span>

                                        @elseif($row['status'] == 'never')
                                            <span class="px-3 py-1 inline-flex text-xs leading-5 font-semibold rounded-full bg-gray-100 text-gray-600 border border-gray-200">
                                                ✨ {{ $row['alert_message'] }}
                                            </span>

                                        @else
                                            <span class="px-3 py-1 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800">
                                                ✅ Cliente Constante
                                            </span>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @endif

        </div>
    </div>
</div>