<div class="py-6">
    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        
        <h2 class="text-2xl font-bold text-gray-800 mb-6">📊 Reporte de Ventas</h2>

        <div class="bg-white p-4 rounded-lg shadow mb-6 flex gap-4 overflow-x-auto">
            <button wire:click="$set('range', 'today')" 
                    class="px-4 py-2 rounded font-medium transition {{ $range == 'today' ? 'bg-indigo-600 text-white shadow-md' : 'bg-gray-100 text-gray-600 hover:bg-gray-200' }}">
                📅 Hoy
            </button>
            <button wire:click="$set('range', 'week')" 
                    class="px-4 py-2 rounded font-medium transition {{ $range == 'week' ? 'bg-indigo-600 text-white shadow-md' : 'bg-gray-100 text-gray-600 hover:bg-gray-200' }}">
                🗓️ Esta Semana
            </button>
            <button wire:click="$set('range', 'month')" 
                    class="px-4 py-2 rounded font-medium transition {{ $range == 'month' ? 'bg-indigo-600 text-white shadow-md' : 'bg-gray-100 text-gray-600 hover:bg-gray-200' }}">
                📆 Este Mes
            </button>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-6">
            
            <div class="bg-gradient-to-br from-green-500 to-green-600 text-white rounded-xl p-6 shadow-lg transform hover:scale-105 transition duration-300">
                <h3 class="text-lg font-semibold opacity-90">Ventas Totales ($)</h3>
                <p class="text-4xl font-extrabold mt-2">${{ number_format($total_usd, 2) }}</p>
                <p class="text-sm mt-2 opacity-75 bg-green-700 bg-opacity-30 inline-block px-2 py-1 rounded">
                    {{ $range == 'today' ? 'Del día de hoy' : 'En el periodo seleccionado' }}
                </p>
            </div>

            <div class="bg-white rounded-xl p-6 shadow-lg border-l-4 border-indigo-500">
                <div class="flex items-center justify-between">
                    <div>
                        <h3 class="text-gray-500 font-bold uppercase text-xs tracking-wider">N° Pedidos</h3>
                        <p class="text-3xl font-bold text-gray-800 mt-1">{{ $total_sales_count }}</p>
                    </div>
                    <div class="p-3 bg-indigo-100 rounded-full text-indigo-600">
                        🛒
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-xl p-6 shadow-lg border-l-4 border-orange-500">
                <div class="flex items-center justify-between">
                    <div>
                        <h3 class="text-gray-500 font-bold uppercase text-xs tracking-wider">Ticket Promedio</h3>
                        <p class="text-3xl font-bold text-gray-800 mt-1">${{ number_format($average_ticket, 2) }}</p>
                    </div>
                    <div class="p-3 bg-orange-100 rounded-full text-orange-600">
                        📈
                    </div>
                </div>
                <p class="text-xs text-gray-400 mt-2">Promedio de consumo por cliente</p>
            </div>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
            
            <div class="bg-white shadow-lg rounded-xl overflow-hidden border border-gray-100">
                <div class="bg-gray-50 px-5 py-4 border-b border-gray-100">
                    <h3 class="font-bold text-gray-800 flex items-center">
                        📜 Historial de Ventas
                    </h3>
                </div>
                <div class="overflow-y-auto max-h-96">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50 sticky top-0">
                            <tr>
                                <th class="px-5 py-3 text-left text-xs font-bold text-gray-500 uppercase">Fecha</th>
                                <th class="px-5 py-3 text-left text-xs font-bold text-gray-500 uppercase">Cliente</th>
                                <th class="px-5 py-3 text-right text-xs font-bold text-gray-500 uppercase">Total</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @forelse($sales as $sale)
                                <tr class="hover:bg-gray-50 transition">
                                    <td class="px-5 py-4 whitespace-nowrap text-sm text-gray-500">
                                        {{ $sale->sale_date->format('d/m/Y') }}
                                    </td>
                                    <td class="px-5 py-4 whitespace-nowrap text-sm font-medium text-gray-900">
                                        {{ $sale->client->name }}
                                        @if($sale->client->company_name)
                                            <span class="text-xs text-gray-400 block">{{ $sale->client->company_name }}</span>
                                        @endif
                                    </td>
                                    <td class="px-5 py-4 whitespace-nowrap text-sm text-right text-green-600 font-bold">
                                        ${{ number_format($sale->total_usd, 2) }}
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="3" class="px-5 py-8 text-center text-gray-500">
                                        No hay ventas registradas en este periodo.
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="bg-white shadow-lg rounded-xl overflow-hidden border border-gray-100">
                <div class="bg-red-50 px-5 py-4 border-b border-red-100 flex items-center justify-between">
                    <h3 class="font-bold text-red-700 flex items-center">
                        ⚠️ Clientes "Perdidos"
                    </h3>
                    <span class="text-xs bg-red-200 text-red-800 py-1 px-2 rounded-full font-bold">+30 días sin comprar</span>
                </div>
                <div class="overflow-y-auto max-h-96 p-0">
                    @if($inactive_clients->count() > 0)
                        <ul class="divide-y divide-gray-200">
                            @foreach($inactive_clients as $client)
                                <li class="px-5 py-4 hover:bg-gray-50 transition flex justify-between items-center group">
                                    <div>
                                        <p class="text-sm font-bold text-gray-900">{{ $client->name }}</p>
                                        <p class="text-xs text-gray-500">{{ $client->company_name ?? 'Particular' }}</p>
                                        <p class="text-xs text-gray-400 mt-1">📞 {{ $client->phone ?? 'Sin teléfono' }}</p>
                                    </div>
                                    <a href="tel:{{ $client->phone }}" class="opacity-0 group-hover:opacity-100 transition inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-indigo-100 text-indigo-700 hover:bg-indigo-200">
                                        Contactar
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    @else
                        <div class="flex flex-col items-center justify-center h-48 text-center px-4">
                            <div class="text-4xl mb-2">🎉</div>
                            <p class="text-green-600 font-medium">¡Excelente trabajo!</p>
                            <p class="text-sm text-gray-500">Todos tus clientes han comprado recientemente.</p>
                        </div>
                    @endif
                </div>
            </div>

        </div>
    </div>
</div>