<div class="py-6">
    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg p-6">
            
            <h2 class="text-2xl font-bold text-gray-800 mb-6">Registrar Venta / Pedido</h2>

            @if (session()->has('message'))
                <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-6">
                    <p class="font-bold">¡Listo!</p>
                    <p>{{ session('message') }}</p>
                </div>
            @endif

            <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-6 bg-gray-50 p-4 rounded-lg">
                <div>
                    <label class="block text-gray-700 font-bold mb-2">Cliente:</label>
                    <select wire:model="client_id" class="w-full border-gray-300 rounded-lg shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
                        <option value="">-- Seleccionar --</option>
                        @foreach($clients as $client)
                            <option value="{{ $client->id }}">{{ $client->name }} {{ $client->company_name ? "($client->company_name)" : '' }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="block text-gray-700 font-bold mb-2">Fecha:</label>
                    <input type="date" wire:model="sale_date" class="w-full border-gray-300 rounded-lg shadow-sm">
                </div>
                <div>
                    <label class="block text-blue-800 font-bold mb-2">Tasa BCV (Bs):</label>
                    <input type="number" step="0.01" wire:model.live="bcv_rate" class="w-full border-blue-300 bg-blue-50 rounded-lg shadow-sm font-bold text-lg">
                </div>
            </div>

            <div class="mb-6">
                <h3 class="text-lg font-semibold mb-2">Productos</h3>
                
                @foreach($orderProducts as $index => $row)
                    <div class="flex flex-col md:flex-row gap-2 mb-2 items-end border-b pb-2 md:border-none">
                        <div class="w-full md:w-5/12">
                            <label class="text-xs text-gray-500 md:hidden">Producto</label>
                            <select wire:model.live="orderProducts.{{ $index }}.product_id" class="w-full border-gray-300 rounded shadow-sm">
                                <option value="">Seleccionar...</option>
                                @foreach($products as $product)
                                    <option value="{{ $product->id }}">{{ $product->name }} (${{ $product->price_usd }})</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="w-full md:w-2/12">
                            <label class="text-xs text-gray-500 md:hidden">Cant</label>
                            <input type="number" step="0.1" placeholder="Cant." wire:model.live="orderProducts.{{ $index }}.quantity" class="w-full border-gray-300 rounded shadow-sm">
                        </div>

                        <div class="w-full md:w-2/12">
                            <label class="text-xs text-gray-500 md:hidden">Precio $</label>
                            <input type="text" readonly value="${{ number_format($row['price'], 2) }}" class="w-full bg-gray-100 border-transparent rounded text-gray-600">
                        </div>

                        <div class="w-full md:w-2/12">
                             <label class="text-xs text-gray-500 md:hidden">Subtotal $</label>
                            <input type="text" readonly value="${{ number_format($row['subtotal'], 2) }}" class="w-full bg-gray-100 border-transparent rounded font-bold text-gray-800">
                        </div>

                        <div class="w-full md:w-1/12">
                            <button wire:click="removeProductRow({{ $index }})" class="w-full bg-red-100 text-red-600 hover:bg-red-200 rounded p-2">
                                🗑️
                            </button>
                        </div>
                    </div>
                @endforeach

                <button wire:click="addProductRow" class="mt-2 text-indigo-600 font-bold hover:underline text-sm">
                    + Agregar otro producto
                </button>
            </div>

            <div class="flex flex-col items-end border-t pt-4">
                <div class="w-full md:w-1/3 space-y-2">
                    <div class="flex justify-between text-lg">
                        <span class="text-gray-600">Total USD:</span>
                        <span class="font-bold text-xl text-green-600">${{ number_format($total_usd, 2) }}</span>
                    </div>
                    <div class="flex justify-between text-lg">
                        <span class="text-gray-600">Total BS (Tasa {{ $bcv_rate }}):</span>
                        <span class="font-bold text-xl text-blue-600">Bs {{ number_format($total_ves, 2) }}</span>
                    </div>
                    
                    <button wire:click="saveSale" class="w-full mt-4 bg-gray-900 hover:bg-gray-800 text-white font-bold py-3 px-4 rounded-lg shadow-lg text-lg transition transform active:scale-95">
                        ✅ REGISTRAR VENTA
                    </button>
                </div>
            </div>

        </div>
    </div>
</div>